/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.scanner;

import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffect;
import org.orecruncher.environs.library.BlockStateUtil;
import org.orecruncher.environs.scanner.CuboidScanner;
import org.orecruncher.environs.scanner.ScanContext;

@OnlyIn(value=Dist.CLIENT)
public class AlwaysOnBlockEffectScanner
extends CuboidScanner {
    public AlwaysOnBlockEffectScanner(@Nonnull ScanContext locus, int range) {
        super(locus, "AlwaysOnBlockEffectScanner", range, 0);
    }

    @Override
    protected boolean interestingBlock(BlockState state) {
        return BlockStateUtil.getData(state).hasAlwaysOnEffects();
    }

    @Override
    public void blockScan(@Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random rand) {
        IBlockReader provider = this.locus.getWorld();
        Collection<BlockEffect> effects = BlockStateUtil.getData(state).getAlwaysOnEffects();
        for (BlockEffect be : effects) {
            if (!be.canTrigger(provider, state, pos, rand)) continue;
            be.doEffect(provider, state, pos, rand);
        }
    }
}

